//	CDisk.h

#ifndef _H_CDisk
#define _H_CDisk

#include "CFolder.h"
#include "CEntry.h"
#include "GenStructs.h"
#include "ADFS_Menus.h"

class CDiskMapWindow;
class CDisk;
class CDesktop;

struct ND_DiscFormatRec;

class CDisk : public CEntry {
	
	public:	OSErr		IDisk(
		CDesktop		*desktop, 
		DiskImageRec	*imageRec);
	
			short		GetSectorOrderForIcon(void);
	
	virtual	void		Dispose(void);
		
	virtual	void		Dismount(void);
	virtual	OSErr		Remount(CDisk **diskPP0 = NULL);

	virtual	ushort		GetFileType_ProEquiv(void);

	virtual	OSErr		EntryPane_CB_EntryArray(
		TA_IterateType taType, TA_IterateData *cbData);

	virtual	Err			EntryDispatchCB(
		O_CBType			cbType, 
		O_CBDataP			cbData);

	virtual	OSErr		VerifyFreeSpace(ulong sizeL);
	virtual	ulong		GetVolumeMaxFileSize(ushort pro_fileTypeS);
	virtual ulong		CalcBytesUsedByFile(ulong fileSize);
	virtual	ulong		GetVolumeBytesUsed(void);
	virtual	ulong		GetVolumeBytesFree(void);
	virtual	ulong		GetPhysicalSize(void);
	virtual	ulong		GetLogicalSize(void);
	virtual	ulong		GetVolumeSize(void);
	virtual	OSErr		CacheDiskImage(void);
	virtual	OSErr		UnCacheDiskImage(void);
	
	virtual	OSErr		FlushMemDisk(Boolean flushB);

	/**************************/
	Gen_AllocNodeRec	*GetNodeRec(
		Gen_AllocMap		*blockBitMapP, 
		Gen_AllocTypeRec	*allocTypeRecP, 
		ushort				curSectorS);

	OSErr				AddSectorsToMap(
		CEntry			*entryP, 
		Gen_EntryAlloc	*entrySectorsP, 
		Gen_AllocMap	*blockBitMapP);

	OSErr				RemoveSectorsFromMap(
		CEntry			*entryP, 
		Gen_EntryAlloc	*entrySectorsP, 
		Gen_AllocMap	*blockBitMapP);

	void				DisposeBlockMap(
		Gen_AllocMap	*blockMapP, 
		Boolean			onlyMapB = FALSE);
		
	/**************************/
	virtual	MenuRef		GetFileTypeMenu(void);
	virtual	OSErr		BuildFileTypeMenu(void);
	virtual	short		MenuItemToFileType(short menuItem, ushort *auxType);
	virtual	short		FileTypeToMenuItem(Byte fileType, short auxType);

	virtual	char		*GetWhereString(char *buf256);
	virtual	char		*GetStorageStr(char *buf256);

	virtual	OSErr		DragReceiveFlavor(
		DragReference	theDrag, 
		ItemReference	itemRef, 
		FlavorType		flavorType, 
		void			*data);

	virtual	OSErr		CanAcceptFlavor(
		DragReference	theDrag, 
		ItemReference	itemRef, 
		FlavorType		flavorType, 
		Boolean			*goodFlavorB);

	virtual	Boolean		SetDiskFormat(ND_DiscFormatRec	*formatP);
	void				DoSectorOrderDlg(void);

	virtual	void		Map(void);

	virtual	OSErr		ZeroUnused(void);
	virtual	OSErr		Optimize(void);
	virtual	OSErr		Erase(Boolean confirmB);

	virtual	Boolean					SupportsForks(void);
	virtual	ushort					GetSectorsPerBlock(void);
	virtual	ushort					GetBlocksPerTrack(void);
	virtual	Gen_AllocSizeType		GetAllocSize(void);

	virtual	ushort		TrackSectorToBlock(short trackS, short sectorS);	
	virtual	void		BlockToTrackSectors(
		ushort	block, 
		ushort	*trackS, 
		ushort	sectorA[]);
		
	virtual	OSErr		EntryBlocksToSectors(Gen_EntryAlloc	*sectorListP);
	virtual	OSErr		GetBlockMap(Gen_AllocMap **blockMapH);
	virtual	OSErr		GetSectorMap(Gen_AllocMap **blockMapH);

	short				SkewSector(short sectorS, Boolean reverseB = FALSE);
	virtual	OSErr		Duplicate(void);
	virtual	void		UpdateMenus(void);
	virtual	Boolean		DoCommand(long command);

	OSErr				DuplicateToTemp(void);
	OSErr				ExchangeTemp(void);
	OSErr				DeleteTemp(void);
	virtual	Boolean		IsLocked(void);
		
	virtual	ulong			GetTotalBlocks(void);
	virtual	OSErr			SetGenericBlock(ushort blockNumS, Gen_Block *blockP);
	virtual	OSErr			GetGenericBlock(ushort blockNumS, Gen_Block **blockP);
	virtual	void			UnCacheFolderSizes(void);
	virtual	OSErr			NewDisk_Completion(ADFS_NewDiskCompletionRec *recP);
	virtual	OSErr			Flush(void);
	virtual OSErr			Purge(Boolean criticalB);

	void				ImageToDisk(void);
	void				DiskToImage(void);
	
	virtual	OSErr		ToggleDeletedFiles(void);
	virtual	OSErr		UpdateSort(Boolean recursiveB = FALSE);
	
	Gen_AllocType		SpecifyAllocFileType(Gen_AllocType allocType, ADFS_FileType fileType);

	/****************************************************/
	CDiskMapWindow		*i_diskMapP;
	CDesktop			*i_desktop;
	DiskImageRec		*i_imageRec;
	short				i_flushMemLevel;
	MenuRef				i_fileTypeMenu;
	Boolean				i_pending_flushB;
	Boolean				i_show_deletedB;
	Boolean				i_prev_show_deletedB;
	
	CFolderUnion		i_rootDir;
	
	/******************** disk map stuff */
	/*
		i_diskMysteryAllocP is used while constructing the alloc map
		for a disk.  First these are added into the map:
		Gen_Alloc_BOOT
		Gen_Alloc_DIRECTORY
		Gen_Alloc_V_BITMAP
		Gen_Alloc_NONE	//	empty
		
		then, we want to gather the "mystery" blocks that don't
		belong to any Gen_Alloc_FILE (already stored in the i_mapRec)
		and also don't belong to anything found above.  the list 
		found above is stuffed in this variable while gathering
		mystery blocks
	*/
	Gen_EntryAlloc		*i_diskMysteryAllocP;
	ulong				i_blocksInVolume;
	Gen_AllocMap		i_mapRec;

	private:
	//	used during optimize
	FSSpec				i_tempFileSpec;
	
	typedef CEntry _inherited;
};

#endif
